IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Proyecto_Actualizar_Item]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cbtes_Proyecto_Actualizar_Item] 
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Proyecto_Actualizar_Item]
@pId_Trans		INT,			/*Cbtes_Items*/
@pItem			SMALLINT,		/*Cbtes_Items*/
@pFlag_QA 		CHAR(1),			/*P: Pendiente de Aprobar | R: Rechazado | O: Observado | A: Aprobado*/
@pObservacion	VARCHAR(MAX)
AS

DECLARE @Trans TABLE (ErrorNumber	INT 
					,ErrorSeverity  INT 
					,ErrorState		INT
					,ErrorProcedure	VARCHAR(100)
					,ErrorLine		INT
					,ErrorMessage	VARCHAR(1000)
					,Item			SMALLINT)

/*Declaracion Variables Locales*/
DECLARE @Flag_Existe_Trans			TINYINT
DECLARE @Flag_Tiene_Observados		TINYINT
DECLARE @Id_Estado_Cbte				INT

DECLARE @Mensaje				VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

PRINT 'Procedimiento: CP_Cbtes_Proyecto_Actualizar_Item'

BEGIN TRY
	BEGIN TRAN

	SET @Flag_Existe_Trans = ISNULL((SELECT 1 FROM Cbtes WHERE Id_Trans = @pId_Trans), 0)
	IF (@Flag_Existe_Trans = 0)
	BEGIN
		SET @Mensaje = 'No existe la Transaccion'

		SELECT	2001			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@pItem			AS Item
		ROLLBACK
		RETURN
	END

	/*************************************************************************************************/
	
	UPDATE Cbtes_Items
	SET
		Flag_QA = @pFlag_QA,
		Observacion = CONVERT(VARCHAR(MAX), Observacion) + CHAR(13) + @pObservacion
	WHERE
		Id_Trans = @pId_Trans
		AND Item = @pItem
	

	/* Verifico el estado del requerimiento y si tiene algun item observado */
	SET @Id_Estado_Cbte = (SELECT CB.Id_Estado_Cbte FROM Cbtes CB WHERE CB.Id_Trans = @pId_Trans)
	SET @Flag_Tiene_Observados = ISNULL((SELECT top 1 1 FROM cbtes_items WHERE Id_Trans = @pId_Trans AND Flag_QA='O'), 0)

	/* Si esta pendiente y tiene un item observado; pasar requerimiento a observado */
	if (@Id_Estado_Cbte = 1 AND @Flag_Tiene_Observados = 1)
	BEGIN
		EXEC CP_Cbtes_Proyecto_Actualizar @pId_Trans, 'O', ''
	END

	/* Si esta observado y no tiene ningun item observado; pasar a pendiente */
	if (@Id_Estado_Cbte = 80 AND @Flag_Tiene_Observados = 0)
	BEGIN
		EXEC CP_Cbtes_Proyecto_Actualizar @pId_Trans, 'P', ''
	END
	


	/************************************************************************************************/
	
	COMMIT

	SET @Mensaje = 'Item Actualizado'

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			,@pItem			AS Item

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH

PRINT 'FIN Procedimiento: CP_Cbtes_Proyecto_Actualizar_Item'